<?php
/**
 * Template name: HeaderSidebar
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
    <link rel="profile" href="//gmpg.org/xfn/11">
    <?php
    /**
     * Functions hooked in to wp_head action
     *
     * @see freshio_pingback_header - 1
     */
    wp_head();

    ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<?php do_action('freshio_before_site'); ?>

<div id="page" class="hfeed site">
    <?php
    /**
     * Functions hooked in to freshio_before_header action
     *
     */
    do_action('freshio_before_header');
    if (freshio_is_elementor_activated() && function_exists('hfe_init') && hfe_header_enabled()) {
        do_action('hfe_header');
    } else {
        get_template_part('template-parts/header/header-6');
    }

    /**
     * Functions hooked in to freshio_before_content action
     *
     */
    do_action('freshio_before_content');
    ?>

    <div id="content" class="site-content" tabindex="-1">
        <div class="col-full">

            <?php
            /**
             * Functions hooked in to freshio_content_top action
             *
             * @see freshio_shop_messages - 10 - woo
             *
             */
            do_action('freshio_content_top');

            ?>
            <div id="primary" class="content-area">
                <main id="main" class="site-main" role="main">
                    <?php
                    while (have_posts()) :
                        the_post();
                        the_content();
                    endwhile; // End of the loop.
                    ?>
                </main><!-- #main -->
            </div><!-- #primary -->

        </div><!-- .col-full -->


    <?php do_action('freshio_before_footer');
    if (freshio_is_elementor_activated() && function_exists('hfe_init') && (hfe_footer_enabled() || hfe_is_before_footer_enabled())) {
        do_action('hfe_footer_before');
        do_action('hfe_footer');
    } else {
        ?>

        <footer id="colophon" class="site-footer" role="contentinfo">
            <?php
            /**
             * Functions hooked in to freshio_footer action
             *
			 * @see freshio_footer_default - 20
			 * @see freshio_handheld_footer_bar - 25 - woo
             *
             *
             */
            do_action('freshio_footer');

            ?>

        </footer><!-- #colophon -->

        <?php
    }

    /**
     * Functions hooked in to freshio_after_footer action
     * @see freshio_sticky_single_add_to_cart    - 999 - woo
     */
    do_action('freshio_after_footer');
    ?>
    </div><!-- #content -->

</div><!-- #page -->

<?php

/**
 * Functions hooked in to wp_footer action
 * @see freshio_template_account_dropdown    - 1
 * @see freshio_mobile_nav - 1
 * @see freshio_render_woocommerce_shop_canvas - 1 - woo
 */

wp_footer();
?>
</body>
</html>
