<?php
/**
 * This file belongs to the YIT Plugin Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package YITH WooCommerce Request A Quote Premium
 * @var WP_List_Table $table
 * @var bool          $is_blank
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


?>
<div class="ywdpd-admin-wrap-content">


	<?php
	/**
	 * This file belongs to the YIT Plugin Framework.
	 *
	 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
	 * that is bundled with this package in the file LICENSE.txt.
	 * It is also available through the world-wide-web at this URL:
	 * http://www.gnu.org/licenses/gpl-3.0.txt
	 *
	 * @package YITH WooCommerce Request A Quote Premium
	 */

	/**
	 * Admin View: Exclusions List Table
	 */

	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}
	?>
	<div class="wrap ywdpd-exclusion-list-tab">
		<div class="icon32 icon32-posts-post" id="icon-edit"><br/></div>
		<div class="wrap-title">
			<h2><?php esc_html_e( 'Exclusion List', 'ywdpd' ); ?></h2>
			<?php
			if ( $table->has_items() ) :
				?>
				<div class="ywdpd-add-exclusions" style="display: inline-block;">
					<a class="yith-add-button" href="#"><?php esc_html_e( 'Add exclusion', 'ywdpd' ); ?></a>
				</div>
			<?php
			endif;
			?>
		</div>
		<?php
		$args = array(
			'type' => 'simple-text',
			'desc' => __( 'Items added to the Exclusion List will be automatically excluded from all the rules', 'ywdpd' ),
		);
		yith_plugin_fw_get_field( $args, true );
		?>

		<?php if ( $is_blank ) : ?>
			<div class="ywdpd-admin-no-posts">
				<div class="ywdpd-admin-no-posts-container">
					<div class="ywdpd-admin-no-posts-logo">
						<img width="80" src="<?php echo esc_url( YITH_YWDPD_ASSETS_URL . '/icons/exclusion-list.svg' ); ?>">
					</div>
					<div class="ywdpd-admin-no-posts-text">
						<span>
							<strong><?php echo esc_html_x( 'You don\'t have any excluded items yet.', 'Text showed when the list of quotes is empty.', 'ywdpd' ); ?></strong>
						</span>
						<p><?php echo esc_html_x( 'Click on the "Add exclusion" button to exclude a product, a category or a tag!', 'Text showed when the list of quotes is empty.', 'ywdpd' ); ?></p>
					</div>
					<div class="ywdpd-add-exclusions">
						<a class="yith-add-button" href="#"><?php esc_html_e( 'Add exclusion', 'ywdpd' ); ?></a>
					</div>
				</div>
			</div>
		<?php else : ?>
			<div class="yith-plugin-ui--classic-wp-list-style">
				<form method="get">
					<input type="hidden" name="page" value="<?php echo esc_attr( $get['page'] ); ?>">
					<input type="hidden" name="tab" value="exclusions">
					<?php $table->display(); ?>
				</form>
			</div>
		<?php endif; ?>

	</div>
</div>

