<?php
/**
 * This file belongs to the YIT Plugin Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package YITH WooCommerce Request A Quote Premium
 * @var WP_List_Table $table
 * @var bool          $is_blank
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<div class="yith-exclusion-list__popup_wrapper">
	<form method="post" class="yith-exclusion-list__form_row">
		<input type="hidden" name="_nonce" value="<?php echo sanitize_key( wp_create_nonce( 'yith_ywdpd_add_exclusions' ) ); ?>"/>
		<div class="ywdpd-field">
			<label for="ywdpd-exclusion-type"><?php esc_html_e( 'Exclusion type', 'ywdpd' ); ?></label>
			<div class="ywdpd-field-input">
				<select name="ywdpd-exclusion-type" id="ywdpd-exclusion-type" class="wc-enhanced-select" style="width: 300px">
					<option value="product"><?php esc_html_e( 'Product', 'ywdpd' ); ?></option>
					<option value="product_cat"><?php esc_html_e( 'Category', 'ywdpd' ); ?></option>
					<option value="product_tag"><?php esc_html_e( 'Tag', 'ywdpd' ); ?></option>
				</select>
				<span class="description"><?php esc_html_e( 'Choose if you want to add a product, a category or a tag.', 'ywdpd' ); ?></span>
			</div>
		</div>
		<div class="ywdpd-field ywdpd-exclusion-field ywdpd-exclusion-product" dep-value="product">
			<label for="ywdpd-exclusion-type"><?php esc_html_e( 'Choose products to add', 'ywdpd' ); ?></label>
			<?php
			$field_args = array(
				'id'       => 'add_product',
				'type'     => 'ajax-products',
				'name'     => 'ywdpd_add_product',
				'data'     => array(
					'action'   => 'woocommerce_json_search_products_and_variations',
					'security' => wp_create_nonce( 'search-products' ),
				),
				'multiple' => true,
			);
			?>
			<div class="ywdpd-field-input">
				<?php
				yith_plugin_fw_get_field( $field_args, true, false );
				?>
				<span class="description"><?php esc_html_e( 'Choose the products to add to the exclusion list', 'ywdpd' ); ?></span>
			</div>
		</div>
		<div class="ywdpd-field ywdpd-exclusion-field ywdpd-exclusion-category" dep-value="product_cat">
			<label for="ywdpd-exclusion-type"><?php esc_html_e( 'Choose categories to add', 'ywdpd' ); ?></label>
			<div class="ywdpd-field-input">
				<?php
				yith_plugin_fw_get_field(
					array(
						'type'     => 'ajax-terms',
						'name'     => 'ywdpd_add_product_cat',
						'data'     => array(
							'taxonomy'    => 'product_cat',
							'placeholder' => __( 'Search for a category', 'ywdpd' ),
						),
						'id'       => 'add_categories',
						'multiple' => true,
					),
					true,
					false
				);
				?>
				<span class="description"><?php esc_html_e( 'Choose the categories to add to the exclusion list', 'ywdpd' ); ?></span>
			</div>
		</div>
		<div class="ywdpd-field ywdpd-exclusion-field ywdpd-exclusion-tag" dep-value="product_tag">
			<label for="ywdpd-exclusion-type"><?php esc_html_e( 'Choose tags to add', 'ywdpd' ); ?></label>
			<div class="ywdpd-field-input">
				<?php
				yith_plugin_fw_get_field(
					array(
						'type'     => 'ajax-terms',
						'name'     => 'ywdpd_add_product_tag',
						'data'     => array(
							'taxonomy'    => 'product_tag',
							'placeholder' => __( 'Search for a tag', 'ywdpd' ),
						),
						'id'       => 'add_tag',
						'multiple' => true,
					),
					true,
					false
				);
				?>
				<span class="description"><?php esc_html_e( 'Choose the tags to add to the exclusion list', 'ywdpd' ); ?></span>
			</div>
		</div>
		<div class="ywdpd-field ywdpd-save-button">
			<input type="button" class="yith-save-form yith-plugin-fw__button--primary" value="<?php esc_attr_e( 'Add the exclusion to the list', 'ywdpd' ); ?>">
		</div>
	</form>
</div>
