<?php
/**
 * Customers field.
 *
 * @package YITH\DyanmicPricingAndDiscount\Admin\Templates
 * @author  YITH
 * @var array $args
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post;
extract( $args ); // phpcs:ignore WordPress.PHP.DontExtract
$value       = get_post_meta( $post->ID, $id, true );
$value       = ! is_array( $value ) ? explode( ',', $value ) : $value;
$user_string = array();
if ( ! empty( $value ) ) {
	foreach ( $value as $key => $customer_id ) {
		$user = get_user_by( 'id', $customer_id );
		if ( $user ) {
			$user_string[ $customer_id ] = esc_html( $user->display_name ) . ' (#' . absint( $user->ID ) . ' &ndash; ' . esc_html( $user->user_email );
		} else {
			unset( $value[ $key ] );
		}
	}
}

?>

<?php if ( function_exists( 'yith_field_deps_data' ) ) : ?>
<div id="<?php echo esc_attr( $id ); ?>-container" <?php echo yith_plugin_fw_html_data_to_string( $args['data'] ); //phpcs:ignore WordPress.Security.EscapeOutput ?>
	class="yith-plugin-fw-metabox-field-row yith-plugin-fw--required">
	<?php else : ?>
	<div id="<?php echo esc_attr( $id ); ?>-container"
		<?php
		if ( isset( $deps ) ) :
			?>
			data-field="<?php echo esc_attr( $id ); ?>" data-dep="<?php echo esc_attr( $deps['ids'] ); ?>" data-value="<?php echo esc_attr( $deps['values'] ); ?>" <?php endif ?>>
		<?php endif; ?>
		<label for="<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $label ); ?></label>

		<?php
		if ( function_exists( 'yit_add_select2_fields' ) ) {
			$args = array(
				'type'             => 'hidden',
				'class'            => 'wc-customer-search',
				'id'               => $id,
				'name'             => $name,
				'data-placeholder' => esc_attr( $placeholder ),
				'data-allow_clear' => false,
				'data-selected'    => $user_string,
				'data-multiple'    => true,
				'value'            => implode( ',', $value ),
				'style'            => 'width:500px',
			);

			yit_add_select2_fields( $args );
		}
		?>

	</div>
