<?php
/**
 * This file manage a popup template
 *
 * @package YITH\DynamicPricingAndDiscounts
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$rules        = array(
	array(
		array(
			'type'    => 'special_offer',
			'subtype' => 'three_x_two',
			'title'   => _x( '3x2', 'Is a special offer type', 'ywdpd' ),
		),
		array(
			'type'    => 'bogo',
			'title'   => _x( 'Buy 1 Get 1', 'Is a special offer type', 'ywdpd' ),
		),
		array(
			'type'    => 'special_offer',
			'subtype' => 'two_x_one',
			'title'   => _x( '2x1', 'Is a special offer type', 'ywdpd' ),
		),
	),
	array(
		array(
			'type'    => 'special_offer',
			'subtype' => 'off_2dn_unit',
			'title'   => _x( '2dn unit discount', 'Is a special offer type', 'ywdpd' ),
		),
		array(
			'type'    => 'whole_discount',
			'subtype' => 'scheduled',
			'title'   => _x( 'Black Friday discount', 'Is a whole discount type', 'ywdpd' ),
		),
		array(
			'type'    => 'quantity_table',
			'subtype' => '',
			'icon'    => '',
			'title'   => __( 'Quantity & prices table', 'ywdpd' ),
		),
	),
	array(
		array(
			'type'    => 'whole_discount',
			'subtype' => 'user',
			'title'   => _x( 'Discount for user role', 'Is a whole discount type', 'ywdpd' ),
		),
		array(
			'type'    => 'special_offer',
			'subtype' => 'buy_x_get_y',
			'title'   => _x( 'Buy X and get Y for free', 'Is a special offer type', 'ywdpd' ),
		),
		array(
			'type'    => 'gift_rule',
			'subtype' => '',
			'title'   => __( 'Offer a gift product at cart', 'ywdpd' ),
		),
	),
	array(
		array(
			'type'    => 'cart_rule',
			'subtype' => '',
			'title'   => __( 'Cart Discount', 'ywdpd' ),
		),
		array(
			'type'    => 'cart_rule',
			'subtype' => 'free_shipping',
			'title'   => __( 'Free shipping for orders over 100$', 'ywdpd' ),
		),
	),
);
$simple_rules = array(
	'simple_qty'               => __( 'Set a quantity discount >', 'ywdpd' ),
	'simple_special_offer'     => __( 'Create a special offer >', 'ywdpd' ),
	'simple_gift_products'     => __( 'Gift products >', 'ywdpd' ),
	'simple_whole_shop'        => __( 'Set a discount on whole shop >', 'ywdpd' ),
	'simple_category_discount' => __( 'Set a category discount >', 'ywdpd' ),
	'simple_cart_rule'         => __( 'Set a cart discount >', 'ywdpd' ),
);
?>
<div id="ywdpd_rule_manger_popup">
	<div class="ywdpd_manager_popup_container">
		<div class="ywdpd_left">
			<h3><?php esc_html_e( 'Start from a template', 'ywdpd' ); ?></h3>
			<div class="ywdpd_rules">
				<?php
				foreach ( $rules as $row ) :
					?>
					<div class="ywdpd_row">
						<?php
						foreach ( $row as $single_rule ) :
							$icon_class = ! empty( $single_rule['subtype'] ) ? $single_rule['subtype'] : $single_rule['type'];

							$url = add_query_arg(
								array(
									'action' => 'create_dynamic_rule',
									'type'   => $icon_class,
								)
							);
							$url = wp_nonce_url( $url, 'ywdpd-create-pop-rule-' . $icon_class );
							?>
							<a rel="nofollow" href="<?php echo esc_url( $url ); ?> " class="ywdpd_single_rule <?php echo esc_attr( $icon_class ); ?>"><span><?php echo esc_html( $single_rule['title'] ); ?></span></a>
							<?php
						endforeach;
						?>
					</div>
					<?php
				endforeach;
				?>
			</div>
		</div>
		<div class="ywdpd_right">
			<h3><?php esc_html_e( 'Or start from scratch', 'ywdpd' ); ?></h3>
			<ul>
				<?php
				foreach ( $simple_rules as $key => $simple_rule ) :
					$url = add_query_arg(
						array(
							'action' => 'create_simple_dynamic_rule',
							'type'   => $key,
						)
					);
					$url = wp_nonce_url( $url, 'ywdpd-create-pop-simple-rule-' . $key );
					?>
					<li>
						<a rel="nofollow" href="<?php echo esc_url( $url ); ?>"><?php echo esc_html( $simple_rule ); ?></a>
					</li>
					<?php
				endforeach;
				?>
			</ul>
		</div>
	</div>
</div>
