<?php
/**
 * Quantity table options
 *
 * @package YITH\DynamicPricingAndDiscounts
 * @since 3.0.0
 */

defined( 'ABSPATH' ) || exit;

$options = array(
	'quantity-table' => array(
		'general_settings_start'                => array(
			'name' => __( 'Quantity table options', 'ywdpd' ),
			'type' => 'title',
		),
		'product_page_show_qty_table'           => array(
			'id'        => 'ywdpd_show_quantity_table',
			'name'      => __( 'Show quantity tables', 'ywdpd' ),
			'desc'      => __( 'Enable to show a quantity table in all products with a quantity discount rule. Disable to hide all tables.', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'yes',
		),
		'product_page_qty_style'                => array(
			'id'        => 'ywdpd_quantity_table_orientation',
			'name'      => __( 'Table layout in desktop', 'ywdpd' ),
			'desc'      => __( 'Choose the layout for quantity table', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'options'   => array(
				'vertical'   => __( 'Vertical', 'ywdpd' ),
				'horizontal' => __( 'Horizontal', 'ywdpd' ),
			),
			'default'   => 'horizontal',
			'deps'      => array(
				'id'    => 'ywdpd_show_quantity_table',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		'product_page_qty_style_mb'             => array(
			'id'        => 'ywdpd_quantity_table_orientation_mobile',
			'name'      => __( 'Table layout in mobile', 'ywdpd' ),
			'desc'      => __( 'Choose the layout of the quantity table in mobile devices', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'options'   => array(
				'vertical'   => __( 'Vertical', 'ywdpd' ),
				'horizontal' => __( 'Horizontal', 'ywdpd' ),
			),
			'default'   => 'horizontal',
			'deps'      => array(
				'id'    => 'ywdpd_show_quantity_table',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		'product_page_qty_position'             => array(
			'id'        => 'ywdpd_show_quantity_table_place',
			'name'      => __( 'Table position', 'ywdpd' ),
			'desc'      => __( 'Choose where to show the quantity table on product pages', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'select',
			'class'     => 'wc-enhanced-select',
			'options'   => array(
				'shortcode'          => __( 'Use shortcode', 'ywdpd' ),
				'before_add_to_cart' => __( 'Before "Add to cart" button', 'ywdpd' ),
				'after_add_to_cart'  => __( 'After "Add to cart" button', 'ywdpd' ),
				'before_excerpt'     => __( 'Before excerpt', 'ywdpd' ),
				'after_excerpt'      => __( 'After excerpt', 'ywdpd' ),
				'after_meta'         => __( 'After product meta', 'ywdpd' ),
			),
			'default'   => 'before_add_to_cart',
			'deps'      => array(
				'id'    => 'ywdpd_show_quantity_table',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		'qty_table_shortcode'                   => array(
			'id'        => 'ywdpd_qty_table_shortcode',
			'name'      => __( 'Table shortcode', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'copy-to-clipboard',
			'default'   => '[yith_ywdpd_quantity_table]',
			'desc'      => __( 'Copy the shortcode and use it somewhere in the product pages', 'ywdpd' ),
			'deps'      => array(
				'id'    => 'ywdpd_show_quantity_table_place',
				'value' => 'shortcode',
				'type'  => 'hide',
			),
			'readonly'  => true,

		),
		'product_page_qty_title'                => array(
			'id'        => 'ywdpd_show_quantity_table_label',
			'name'      => __( 'Table heading', 'ywdpd' ),
			'desc'      => __( 'Enter a text to identify the quantity table title', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'text',
			'default'   => __( 'Discount per quantity', 'ywdpd' ),
			'deps'      => array(
				'id'    => 'ywdpd_show_quantity_table',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		'show_percentage'                       => array(
			'id'        => 'ywdpd_show_percentage_in_table',
			'name'      => __( 'Show a discount column in tables', 'ywdpd' ),
			'desc'      => __( 'Enable to show the discount column in all tables', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'off',
			'deps'      => array(
				'id'    => 'ywdpd_show_quantity_table',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		'product_page_qty_labels'               => array(
			'id'        => 'ywdpd_quantity_table_labels',
			'name'      => __( 'Table labels', 'ywdpd' ),
			'desc'      => __( 'Enter the labels for the Quantity and Price table.', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'inline-fields',
			'fields'    => array(
				'quantity' => array(
					'label'             => __( 'Quantity', 'ywdpd' ),
					'type'              => 'text',
					'default'           => __( 'Quantity', 'ywdpd' ),
					'custom_attributes' => 'style="width:200px!important;"',
				),
				'price'    => array(
					'label'             => __( 'Price', 'ywdpd' ),
					'type'              => 'text',
					'default'           => __( 'Price', 'ywdpd' ),
					'custom_attributes' => 'style="width:200px!important"',
				),
				'discount' => array(
					'label'             => __( 'Discount', 'ywdpd' ),
					'type'              => 'text',
					'default'           => __( '% Discount', 'ywdpd' ),
					'custom_attributes' => 'style="width:200px!important"',
					'class'             => 'ywdpd_discount_heading',
				),
			),
			'deps'      => array(
				'id'    => 'ywdpd_show_quantity_table',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		'qty_table_type_heading'                => array(
			'id'        => 'ywdpd_qty_table_type_heading',
			'name'      => __( 'In quantity heading show', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'options'   => array(
				'all' => __( 'The quantity ranges used in the discount rules (e.g.: 1-5)', 'ywdpd' ),
				'min' => __( 'Only the minimum quantity of the range (e.g.: 1)', 'ywdpd' ),
				'max' => __( 'Only the maximum quantity of the range (e.g.: 5)', 'ywdpd' ),
			),
			'default'   => 'all',
			'desc'      => __( 'Choose the style of the quantity heading in the tables', 'ywdpd' ),
			'deps'      => array(
				'id'    => 'ywdpd_show_quantity_table',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		'product_page_expire_date'              => array(
			'id'        => 'ywdpd_show_quantity_table_schedule',
			'name'      => __( 'Show the end date of discount in quantity table', 'ywdpd' ),
			'desc'      => __( 'Enable to show when the discount ends in quantity table', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'yes',
			'deps'      => array(
				'id'    => 'ywdpd_show_quantity_table',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		'product_page_show_as_default'          => array(
			'id'        => 'ywdpd_show_as_default',
			'name'      => __( 'Show as default', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'options'   => array(
				'min' => __( 'The first discount rule (usually the minimum discount)', 'ywdpd' ),
				'max' => __( 'The last discount rule (usually the maximum discount)', 'ywdpd' ),
			),
			'default'   => 'min',
			'desc'      => __( 'Choose whether to show the minimum or the maximum discount available as default price in product page and loop', 'ywdpd' ),
			'deps'      => array(
				'id'    => 'ywdpd_show_quantity_table',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		'product_page_default_price_selected'   => array(
			'id'        => 'ywdpd_default_qty_selected',
			'name'      => __( 'Select default quantity in the table', 'ywdpd' ),
			'desc'      => __( 'Enable to automatically select the first quantity rule in the table', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'no',
			'deps'      => array(
				'id'    => 'ywdpd_show_quantity_table',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		'product_page_change_price_dynamically' => array(
			'id'        => 'ywdpd_update_price_on_qty',
			'name'      => __( 'Change product price when user changes quantity', 'ywdpd' ),
			'desc'      => __( 'Enable to show an updated price when the user changes the quantity', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'yes',
			'deps'      => array(
				'id'    => 'ywdpd_show_quantity_table',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		'qty_section_end'                       => array(
			'type' => 'sectionend',
		),
	),
);

return $options;
