<?php
/**
 * General options
 *
 * @package YITH WooCommerce Dynamic Pricing and Discounts Premium
 * @since   1.0.0
 * @version 1.6.0
 * @author  YITH
 */

if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_YWDPD_VERSION' ) ) {
	exit; // Exit if accessed directly.
}
$settings_options = array(
	'general' => array(
		'general_settings_start'          => array(
			'name' => __( 'General Settings', 'ywdpd' ),
			'type' => 'title',
		),
		'general_enable_shop_manager'     => array(
			'id'        => 'ywdpd_enable_shop_manager',
			'name'      => __( 'Allow Shop Manager to manage dynamic pricing and discount', 'ywdpd' ),
			'desc'      => __( 'If enabled, the shop manager can edit the plugin options', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'no',
		),
		'general_price_format'            => array(
			'id'                => 'ywdpd_price_format',
			'name'              => __( 'Price format', 'ywdpd' ),
			'desc'              => sprintf(/* translators: %1$s is the field description %2$s is the description of the placeholders */
				'%1$s <p><strong>%2$s</strong></p><br/>&#37;original_price&#37;,&#37;discounted_price&#37;,&#37;percentual_discount&#37;',
				__( 'Enter the price format to show the original price, the percentual discount or discounted price.', 'ywdpd' ),
				__( 'Placeholder available:', 'ywdpd' )
			),
			'type'              => 'yith-field',
			'yith-type'         => 'textarea',
			'custom_attributes' => 'style="resize:none;"',
			'rows'              => 2,
			'default'           => '<del>%original_price%</del> %discounted_price%',
		),
		'show_price_name_details'         => array(
			'id'        => 'ywdpd_show_rule_details',
			'name'      => __( 'Show Price rule details in customer emails', 'ywdpd' ),
			'desc'      => __( 'Enable to add the info about the rule applied in the email sent to customers', 'ywdpd' ),
			'yith-type' => 'onoff',
			'type'      => 'yith-field',
			'default'   => 'yes',
		),
		'general_settings_end'            => array(
			'type' => 'sectionend',
		),
		'product_page_section_start'      => array(
			'name' => __( 'Product page settings', 'ywdpd' ),
			'type' => 'title',
		),
		'product_page_show_message'       => array(
			'id'        => 'ywdpd_show_note_on_products',
			'name'      => __( 'Show the discount custom messages', 'ywdpd' ),
			'desc'      => __( 'For each rule, you can enter a custom message. You can use this option to show or hide all the custom messages on product pages.', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'yes',
		),
		'product_page_message_position'   => array(
			'id'        => 'ywdpd_show_note_on_products_place',
			'name'      => __( 'Message position', 'ywdpd' ),
			'desc'      => __( 'Choose where to show the discount rules messages', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'select',
			'class'     => 'wc-enhanced-select',
			'options'   => array(
				'before_add_to_cart' => __( 'Before "Add to cart" button', 'ywdpd' ),
				'after_add_to_cart'  => __( 'After "Add to cart" button', 'ywdpd' ),
				'before_excerpt'     => __( 'Before excerpt', 'ywdpd' ),
				'after_excerpt'      => __( 'After excerpt', 'ywdpd' ),
				'after_meta'         => __( 'After product meta', 'ywdpd' ),

			),
			'default'   => 'before_add_to_cart',
			'deps'      => array(
				'id'    => 'ywdpd_show_note_on_products',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		'product_page_section_end'        => array(
			'type' => 'sectionend',
		),
		'cart_section_start'              => array(
			'type' => 'title',
			'name' => __( 'Cart settings', 'ywdpd' ),
		),
		'cart_how_show_cart_label'        => array(
			'id'        => 'ywdpd_cart_label_mode',
			'name'      => __( 'In the cart page show', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'options'   => array(
				'default_name' => __( 'A single label to identify all of the cart rules applied', 'ywdpd' ),
				'list_of_name' => __( 'The list of all of the cart rules applied', 'ywdpd' ),
			),
			'default'   => 'default_name',
			'desc'      => __( 'Choose how to show the coupon label in the cart', 'ywdpd' ),
		),
		'cart_coupon_setting'             => array(
			'id'        => 'ywdpd_coupon_label',
			'name'      => __( 'Coupon Label', 'ywdpd' ),
			'desc'      => __( 'Enter a text to identify the coupon in cart, when a discount is applied', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'text',
			'default'   => _x( 'DISCOUNT', 'Dynamic coupon label', 'ywdpd' ),
			'deps'      => array(
				'id'    => 'ywdpd_cart_label_mode',
				'value' => 'default_name',
				'type'  => 'hide',
			),
		),
		'cart_coupon_calculation_setting' => array(
			'id'        => 'ywdpd_calculate_discounts_tax',
			'name'      => __( 'Calculate cart discount starting from', 'ywdpd' ),
			'desc'      => __( 'Choose to calculate the cart discount including or excluding tax on the subtotal', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'select',
			'class'     => 'wc-enhanced-select',
			'options'   => array(
				'tax_excluded' => __( 'Subtotal - tax excluded', 'ywdpd' ),
				'tax_included' => __( 'Subtotal - tax included', 'ywdpd' ),
			),
			'default'   => 'tax_excluded',
		),
		'cart_show_subtotal_mode'         => array(
			'id'        => 'ywdp_cart_special_offer_show_subtotal_mode',
			'name'      => __( 'Show special offers in cart by adapting', 'ywdpd' ),
			'desc'      => __( 'Choose how to show the discounts or special prices in cart', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'options'   => array(
				/* translators: %s is the field description */
				'unit_price' => __( 'The unit price', 'ywdpd' ) . sprintf( "<small>%s</small>", __( 'Product price will be adapted based on the offer applied', 'ywdpd' ) ),
				/* translators: %s is the field description */
				'subtotal'   => __( 'The subtitle', 'ywdpd' ) . sprintf( "<small>%s</small>", __( 'The product price will not be adapted, but the price rule will be applied and shown to the subtotal only', 'ywdpd' ) ),
			),
			'default'   => 'unit_price',
		),
		'cart_notices'                    => array(
			'id'        => 'ywdpd_enable_cart_notices',
			'name'      => __( 'Show amount discount info on cart', 'ywdpd' ),
			'desc'      => __( 'Select if you want to show a notice when a discount rule is applied', 'ywdpd' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'no',
		),
		'discount_message_on_cart'        => array(
			'id'                => 'ywdpd_cart_notice_message',
			'name'              => __( 'Add a custom message in the cart totals', 'ywdpd' ),
			'desc'              => __( 'Enter a custom text to show the total discount for the customer on the cart. Please, note, this applies only to "Cart discount rules". You can use the placeholder %total_discount_percentage% to show the discount in percentage, %total_discount_price% to show the discount value', 'ywdpd' ),
			'type'              => 'yith-field',
			'yith-type'         => 'textarea',
			'deps'              => array(
				'id'    => 'ywdpd_enable_cart_notices',
				'value' => 'yes',
				'type'  => 'hide',
			),
			'default'           => __( 'Please note: you\'ve saved %total_discount_percentage% on this order today', 'ywdpd' ),
			'custom_attributes' => 'style="resize:none;"',
		),
		'cart_section_end'                => array(
			'type' => 'sectionend',
		),
	),
);

if ( defined( 'ICL_SITEPRESS_VERSION' ) ) {
	$settings_options['general']['wpml_section_start'] = array(
		'type' => 'title',
		'name' => __( 'WPML settings', 'ywdpd' ),
	);
	$settings_options['general']['wpml_extension']     = array(
		'id'        => 'ywdpd_wpml_extend_to_translated_object',
		'name'      => __( 'Extend the rules to translated contents', 'ywdpd' ),
		'desc'      => __( 'If enabled the rules will be applied also to translated products', 'ywdpd' ),
		'type'      => 'yith-field',
		'yith-type' => 'onoff',
		'default'   => 'no',
	);
	$settings_options['general']['wpml_section_end']   = array(
		'type' => 'sectionend',
	);
}

return apply_filters( 'yith_ywdpd_panel_settings_options', $settings_options );
