<?php
/**
 * Cart discount class.
 *
 * @package YITH WooCommerce Dynamic Pricing and Discounts Premium
 * @since   1.0.0
 * @version 1.6.0
 * @author  YITH
 */

if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_YWDPD_VERSION' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Implements features of YITH WooCommerce Dynamic Pricing and Discounts
 *
 * @class   YITH_WC_Dynamic_Discounts
 * @package YITH WooCommerce Dynamic Pricing and Discounts
 * @since   1.0.0
 * @author  YITH
 */
if ( ! class_exists( 'YITH_WC_Dynamic_Discounts' ) ) {

	/**
	 * Class YITH_WC_Dynamic_Discounts
	 *
	 * @deprecated 3.0.0
	 */
	class YITH_WC_Dynamic_Discounts {

		/**
		 * Single instance of the class
		 *
		 * @var YITH_WC_Dynamic_Discounts
		 */

		protected static $instance;

		/**
		 * Array with discount rules
		 *
		 * @var array
		 */
		public $discount_rules = array();

		/**
		 * Returns single instance of the class
		 *
		 * @return YITH_WC_Dynamic_Discounts
		 * @since 1.0.0
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Return pricing rules filtered and validates
		 *
		 * Initialize plugin and registers actions and filters to be used
		 *
		 * @deprecated 3.0.0
		 * @since  1.0.0
		 * @author Emanuela Castorina
		 */
		public function get_discount_rules() {
			if ( empty( $this->discount_rules ) ) {
				$this->discount_rules = $this->filter_valid_rules( $this->recover_cart_rules() );
			}

			return $this->discount_rules;
		}


		/**
		 * Get the cart rules
		 *
		 * @deprecated 3.0.0
		 * @return array
		 * @author Emanuela Castorina <emanuela.castorina@yithemes.com>
		 */
		public function recover_cart_rules() {

			$cart_rules = ywdpd_recover_rules( 'cart' );

			return $cart_rules;
		}


		/**
		 * Filter valid cart discount rules
		 *
		 * @param array $cart_rules The array version of cart rules.
		 * @deprecated 3.0.0
		 * @return array
		 */
		public function filter_valid_rules( $cart_rules ) {
			yith_ywdpd_deprecated_function( 'YITH_WC_Dynamic_Discounts::filter_valid_rules', '3.0', 'use ywdpd_get_cart_rules instead' );

			$valid_rules = array();
			foreach ( $cart_rules as $cart_rule ) {

				$rule = ywdpd_get_rule( $cart_rule['id'] );

				if ( $rule->is_valid() ) {
					$valid_rules[] = $rule->get_data();
				}
			}

			return $valid_rules;
		}
	}
}

/**
 * Unique access to instance of YITH_WC_Dynamic_Pricing class
 *
 * @return YITH_WC_Dynamic_Discounts
 */
function YITH_WC_Dynamic_Discounts() { // phpcs:ignore
	return YITH_WC_Dynamic_Discounts::get_instance();
}

