<?php
/**
 * Compatibility with YITH MultiCurrency Switcher
 *
 * @package YITH\DynamicPricingAndDiscount\Classes
 */

! defined( 'ABSPATH' ) && exit; // Exit if accessed directly.

/**
 * Class that manange the compatibility with Multi Currency Switcher
 */
class YITH_YWDPD_Multi_Currency_Integration {
	/**
	 * Single instance of the class
	 *
	 * @var YITH_YWDPD_Multi_Currency_Integration
	 */
	protected static $instance;

	/**
	 * Returns single instance of the class
	 *
	 * @return YITH_YWDPD_Multi_Currency_Integration
	 * @since 3.3.0
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Constructor
	 *
	 * Initialize class and registers actions and filters to be used
	 *
	 * @since  3.3.0
	 * @author YITH
	 */
	public function __construct() {
		add_filter( 'ywdpd_price_rule_get_gift_subtotal', array( $this, 'convert_amount' ) );
		add_filter( 'ywdpd_maybe_should_be_converted', array( $this, 'convert_amount' ), 99, 1 );
		add_filter( 'ywdpd_cart_item_display_price', array( $this, 'convert_amount' ), 99, 1 );
		add_filter( 'ywdpd_cart_item_adjusted_price', array( $this, 'convert_amount' ), 99, 1 );
		add_action( 'ywdpd_before_calculate_discounts', array( $this, 'remove_filters' ), 1 );
		add_action( 'ywdpd_after_calculate_discounts', array( $this, 'add_filters' ), 1 );
		add_filter( 'ywdpd_cart_rule_get_minimum_subtotal', array( $this, 'convert_amount' ), 99, 1 );
		add_filter( 'ywdpd_cart_rule_get_maximum_subtotal', array( $this, 'convert_amount' ), 99, 1 );
		add_filter( 'yith_wcmcs_apply_currency_filters', array( $this, 'apply_currency_filter' ), 20 );
	}

	/**
	 * Remove the filters to avoid wrong conversion
	 *
	 * @author YITH
	 * @since 3.3.0
	 */
	public function remove_filters() {
		$multicurrency_product_instance = YITH_WCMCS_Products::get_instance();
		remove_filter( 'ywdpd_maybe_should_be_converted', array( $this, 'convert_amount' ), 99 );
		remove_filter( 'woocommerce_product_get_regular_price', array( $multicurrency_product_instance, 'filter_manual_regular_price' ), 20, );
		remove_filter( 'woocommerce_product_get_sale_price', array( $multicurrency_product_instance, 'filter_manual_sale_price' ), 20 );
		remove_filter( 'woocommerce_product_get_price', array( $multicurrency_product_instance, 'filter_manual_price' ), 20 );
	}

	/**
	 * Add the filters to avoid wrong conversion
	 *
	 * @author YITH
	 * @since 3.3.0
	 */
	public function add_filters() {
		$multicurrency_product_instance = YITH_WCMCS_Products::get_instance();
		add_filter( 'ywdpd_maybe_should_be_converted', array( $this, 'convert_amount' ), 99, 1 );
		add_filter( 'woocommerce_product_get_regular_price', array( $multicurrency_product_instance, 'filter_manual_regular_price' ), 20, 2 );
		add_filter( 'woocommerce_product_get_sale_price', array( $multicurrency_product_instance, 'filter_manual_sale_price' ), 20, 2 );
		add_filter( 'woocommerce_product_get_price', array( $multicurrency_product_instance, 'filter_manual_price' ), 20, 2 );
	}

	/**
	 * Check if there is an ajax action to apply the conversion
	 *
	 * @param bool $apply Apply conversions.
	 *
	 * @return bool
	 * @author YITH
	 * @since 3.3.0
	 */
	public function apply_currency_filter( $apply ) {
		$dynamic_ajax_actions = array(
			'ywdpd_add_gift_to_cart',
			'ywdpd_update_gift_popup',
			'ywdpd_add_special_to_cart',
		);
		$apply                = $apply || isset( $_REQUEST['action'] ) && in_array( $_REQUEST['action'], $dynamic_ajax_actions, true ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended

		return $apply;
	}

	/**
	 * Convert the price to base currency
	 *
	 * @param float $amount the amount to convert.
	 *
	 * @return float
	 * @author YITH
	 * @since 3.3.0
	 */
	public function convert_amount( $amount ) {
		if ( ! is_null( WC()->session ) ) {
			$wc_currency   = WC()->session->get( 'yith_wcmcs_client_currency_id' );
			$base_currency = get_option( 'woocommerce_currency' );

			if ( $base_currency !== $wc_currency ) {
				$amount = apply_filters(
					'yith_wcmcs_convert_price',
					$amount,
					array(
						'from' => $base_currency,
						'to'   => $wc_currency,
					)
				);
			}
		}

		return $amount;
	}
}
