<?php
/**
 * Compatibility with YITH WooCommerce Frequently Bought Together Premium
 *
 * @package YITH WooCommerce Dynamic Pricing and Discounts Premium
 * @since   3.1.0
 * @version 1.0.0
 * @author  YITH
 */

if ( ! defined( 'ABSPATH' ) || ! defined( 'YITH_YWDPD_VERSION' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * YWDPD_Brands class to add compatibility with YITH WooCommerce Brands Add-on Premium
 *
 * @class   YWDPD_Brands
 * @package YITH WooCommerce Dynamic Pricing and Discounts
 * @since   1.1.7
 * @author  YITH
 */
if ( ! class_exists( 'YITH_YWDPD_Frequently_Bought_Together_Integration' ) ) {

	/**
	 * Class YITH_YWDPD_Frequently_Bought_Together_Integration
	 */
	class YITH_YWDPD_Frequently_Bought_Together_Integration {

		/**
		 * Single instance of the class
		 *
		 * @var YITH_YWDPD_Frequently_Bought_Together_Integration
		 */
		protected static $instance;

		/**
		 * Returns single instance of the class
		 *
		 * @return YITH_YWDPD_Frequently_Bought_Together_Integration
		 * @since 1.0.0
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Constructor
		 *
		 * Initialize class and registers actions and filters to be used
		 *
		 * @since  1.1.7
		 * @author Emanuela Castorina
		 */
		public function __construct() {

			add_filter( 'yith_wfbt_price_to_display', array( $this, 'fix_product_price' ), 20, 3 );
		}

		/**
		 * Return the right dynamic price
		 *
		 * @param float                $price The product price.
		 * @param WC_Product           $product The product.
		 * @param WC_Product_Variation $variation The variation.
		 *
		 * @return float
		 * @author YITH
		 * @since 3.1.0
		 */
		public function fix_product_price( $price, $product, $variation ) {
			$prod  = is_null( $variation ) ? $product : $variation;
			$price = ywdpd_dynamic_pricing_discounts()->get_frontend_manager()->get_dynamic_price( $price, $prod );

			return $price;
		}
	}
}
