<?php
/**
 * This class manage the data store of exclusion list
 *
 * @package YITH\DynamicPricingAndDiscounts\Classes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class that manage the query for the exclusion table
 */
class YWDPD_Exclusion_List_Data_Store {
	/**
	 * The table name
	 *
	 * @var string
	 */
	protected static $table_name = 'ywdpd_exclusion_list_table';

	/**
	 * This method create the table if not exist
	 *
	 * @author YITH
	 * @since 3.0.0
	 */
	public static function create_table() {
		global $wpdb;


			$collate = '';

			if ( $wpdb->has_cap( 'collation' ) ) {
				$collate = $wpdb->get_charset_collate();
			}

			$table_name = $wpdb->prefix . 'ywdpd_exclusion_list_table';
			if ( $wpdb->get_var( "SHOW TABLES LIKE '$table_name'" ) != $table_name ) {
				$query = "
			CREATE TABLE  {$wpdb->prefix}ywdpd_exclusion_list_table (
			    ID BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
			    term_id BIGINT(20) UNSIGNED NOT NULL DEFAULT 0,
			    term_type varchar(50) NOT NULL DEFAULT  '',
			    PRIMARY KEY ( ID ),
			    KEY ( term_type ),
			    KEY ( term_id, term_type)
			) $collate;
		";
				if ( ! function_exists( 'dbDelta' ) ) {
					require_once ABSPATH . 'wp-admin/includes/upgrade.php';
				}

				dbDelta( $query );

		}
	}

	/**
	 * Add new row in the table
	 *
	 * @param int    $term_id the term id.
	 * @param string $term_type the term type.
	 *
	 * @author YITH
	 * @since 3.0.0
	 */
	public static function insert( $term_id, $term_type ) {
		global $wpdb;

		$args = array(
			'term_id'   => $term_id,
			'term_type' => $term_type,
		);
		if ( ! self::is_exist( $term_id, $term_type ) ) {
			$wpdb->insert( $wpdb->prefix . self::$table_name, $args, array( '%d', '%s' ) ); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB,DirectDatabaseQuerySniff.NoCaching
		}
	}

	/**
	 * Check if a term exist in the table
	 *
	 * @param int    $term_id The term id.
	 * @param string $term_type The term type.
	 *
	 * @return bool
	 * @author YITH
	 * @since 3.0.0
	 */
	public static function is_exist( $term_id, $term_type ) {

		global $wpdb;
		$tabla_name = $wpdb->prefix . self::$table_name;
		$query      = "SELECT COUNT(ID) FROM {$tabla_name} WHERE term_id = %d AND term_type = %s;";

		$query = $wpdb->prepare( $query, $term_id, $term_type ); // phpcs:ignore  WordPress.DB.PreparedSQL.NotPrepared

		return $wpdb->get_var( $query ) > 0; // phpcs:ignore WordPress.DB,DirectDatabaseQuerySniff.NoCaching
	}

	/**
	 * Check if the table is empty
	 *
	 * @return bool
	 * @author YITH
	 * @since 3.0.0
	 */
	public static function has_items() {

		global $wpdb;
		$tabla_name = $wpdb->prefix . self::$table_name;
		$query      = "SELECT COUNT(ID) FROM {$tabla_name}";

		return $wpdb->get_var( $query ) > 0; // phpcs:ignore WordPress.DB,DirectDatabaseQuerySniff.NoCaching
	}

	/**
	 * Get all terms by type
	 *
	 * @param string $term_type The term type.
	 *
	 * @return array|null
	 * @author YITH
	 * @since 3.0.0
	 */
	public static function get_terms_by_type( $term_type ) {
		global $wpdb;
		$tabla_name = $wpdb->prefix . self::$table_name;
		$query      = "SELECT term_id FROM {$tabla_name} WHERE term_type = %s;";
		$query      = $wpdb->prepare( $query, $term_type ); // phpcs:ignore  WordPress.DB.PreparedSQL.NotPrepared

		return $wpdb->get_col( $query ); // phpcs:ignore WordPress.DB,DirectDatabaseQuerySniff.NoCaching
	}

	/**
	 * Delete an item in the table
	 *
	 * @param int $term_id The item to delete.
	 *
	 * @since 3.0.0
	 * @author YITH
	 */
	public static function delete( $term_id ) {

		global $wpdb;

		$wpdb->delete( $wpdb->prefix . self::$table_name, array( 'term_id' => $term_id ) );// phpcs:ignore WordPress.DB,DirectDatabaseQuerySniff.NoCaching
	}
}
