<?php
/**
 * The class that register the post type
 *
 * @package  YITH WooCommerce Dynamic Pricing and Discounts\Classes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Post type class
 */
class YWDPD_Post_Type {

	/**
	 * This function init the hook for register post type
	 *
	 * @author YITH
	 * @since 3.0.0
	 */
	public static function init() {
		add_action( 'init', array( __CLASS__, 'register_post_type' ), 10 );
	}

	/**
	 * Register the plugin post type
	 *
	 * @author YITH
	 * @since 3.0.0
	 */
	public static function register_post_type() {
		$name          = isset( $_GET['ywdpd_discount_type'] ) && 'cart' === sanitize_text_field( wp_unslash( $_GET['ywdpd_discount_type'] ) ) ? _x( 'Cart Rules', 'Post Type General Name', 'ywdpd' ) : _x( 'Discounts & Price Rules', 'Post Type General Name', 'ywdpd' ); // phpcs:ignore WordPress.Security.NonceVerification
		$singular_name = isset( $_GET['ywdpd_discount_type'] ) && 'cart' === sanitize_text_field( wp_unslash( $_GET['ywdpd_discount_type'] ) ) ? _x( 'Cart Rule', 'Post Type General Name', 'ywdpd' ) : _x( 'Discounts & Price Rule', 'Post Type General Name', 'ywdpd' ); // phpcs:ignore WordPress.Security.NonceVerification

		$labels = array(
			'name'               => $name,
			'singular_name'      => $singular_name,
			'menu_name'          => $singular_name,
			'parent_item_colon'  => __( 'Parent Item:', 'ywdpd' ),
			'all_items'          => __( 'All Discount Rules', 'ywdpd' ),
			'view_item'          => __( 'View Discount Rules', 'ywdpd' ),
			'add_new_item'       => __( '+ Add Rule', 'ywdpd' ),
			'add_new'            => __( '+ Add Rule', 'ywdpd' ),
			'edit_item'          => $singular_name,
			'update_item'        => __( 'Update Discount Rule', 'ywdpd' ),
			'search_items'       => __( 'Search Discount Rule', 'ywdpd' ),
			'not_found'          => __( 'Not found', 'ywdpd' ),
			'not_found_in_trash' => __( 'Not found in Trash', 'ywdpd' ),
		);
		$args   = array(
			'label'               => __( 'ywdpd_discount', 'ywdpd' ),
			'labels'              => $labels,
			'supports'            => array( 'title' ),
			'hierarchical'        => false,
			'public'              => false,
			'show_ui'             => true,
			'show_in_menu'        => false,
			'exclude_from_search' => true,
			'capability_type'     => 'post',
		);

		register_post_type( 'ywdpd_discount', $args );
	}
}

YWDPD_Post_Type::init();
