<?php
/**
 * The class that manage all plugin assets
 *
 * @package YITH\DynamicPricingAndDiscounts\Classes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class YWDPD_Assets
 */
class YWDPD_Assets {

	/**
	 * Contain all ajax frontend actions
	 *
	 * @var array
	 */
	protected static $ajax_frontend_actions;
	/**
	 * Contain all ajax backend actions
	 *
	 * @var array
	 */
	protected static $ajax_backend_actions;

	/**
	 * Init the Assets class
	 *
	 * @author YITH
	 * @since 3.0.0
	 */
	public static function init() {
		self::$ajax_frontend_actions = array(
			'popup_action'   => array(
				'add_gift_to_cart',
				'add_bogo_to_cart',
				'add_special_to_cart',
				'show_second_step',
				'check_variable',
				'update_gift_popup',
				'show_popup_on_shop',
			),
			'product_action' => array(
				'update_product_price',
			),
		);

		self::$ajax_backend_actions = array(
			'table_rule' => array(
				'sort_discount_rules',
				'enable_or_disable_rule',
			),
		);
		add_action( 'wp_enqueue_scripts', array( __CLASS__, 'enqueue_frontend_scripts' ), 20 );
		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueue_admin_scripts' ), 20 );
	}

	/**
	 * Register the frontend scripts
	 *
	 * @author YITH
	 * @since 3.0.0
	 */
	public static function register_frontend_scripts() {

		// Register the popup scripts .
		wp_register_script( 'ywdpd_popup', YITH_YWDPD_ASSETS_URL . '/js/' . yit_load_js_file( 'gift-popup.js' ), array( 'jquery' ), YITH_YWDPD_VERSION, true );
		wp_register_script( 'ywdpd_owl', YITH_YWDPD_ASSETS_URL . '/js/owl/owl.carousel.min.js', array( 'jquery' ), YITH_YWDPD_VERSION, true );
		wp_register_style( 'ywdpd_owl', YITH_YWDPD_ASSETS_URL . '/css/owl/owl.carousel.min.css', array(), YITH_YWDPD_VERSION );
		$args = array(
			'ajax_url'             => admin_url( 'admin-ajax.php', is_ssl() ? 'https' : 'http' ),
			'actions'              => self::get_actions( 'popup_action', 'frontend' ),
			'nonces'               => self::get_nonce( 'popup_action', 'frontend' ),
			'i18n_qty_field_label' => esc_html__( 'Qty in cart', 'ywdpd' ),
			'rtl'                  => is_rtl() ? 'true' : 'false',
		);

		wp_localize_script( 'ywdpd_popup', 'ywdpd_popup_args', $args );

		// End popup scripts.

		// Register the frontend scripts and style.

		$show_minimum_price = 'max' === YITH_WC_Dynamic_Options::get_default_price();
		$template           = YITH_WC_Dynamic_Options::get_quantity_table_layout();
		$change_qty         = YITH_WC_Dynamic_Options::update_price_on_qty_changes();
		$default_qty        = YITH_WC_Dynamic_Options::is_default_qty_selected();
		$args               = array(
			'show_minimum_price'        => yith_plugin_fw_is_true( $show_minimum_price ) ? 'yes' : 'no',
			'template'                  => apply_filters( 'ywdpd_table_orientation', $template ),
			'is_change_qty_enabled'     => $change_qty ? 'yes' : 'no',
			'is_default_qty_enabled'    => $default_qty ? 'yes' : 'no',
			'column_product_info_class' => apply_filters( 'ywdpd_column_product_info_class', '.single-product .summary' ),
			'product_price_classes'     => apply_filters( 'ywdpd_product_price_classes', '.price, .wpb_wrapper .price, .elementor-widget-woocommerce-product-price .price' ),
			'product_qty_classes'       => apply_filters( 'ywdpd_product_qty_classes', ' .qty, .elementor-add-to-cart .qty, .w-post-elm .qty' ),
			'variation_form_class'      => apply_filters( 'ywdpd_variation_form_class', 'form.variations_form.cart' ),
			'select_minimum_quantity'   => apply_filters( 'ywdpd_minimum_quantity', false ),
			'update_prices_in_ajax'     => apply_filters( 'ywdpd_update_prices_in_ajax', 'yes' ),
			'show_variable_table'       => apply_filters( 'ywdpd_show_variable_table', 'yes' ),
			'ajax_url'                  => admin_url( 'admin-ajax.php', is_ssl() ? 'https' : 'http' ),
			'actions'                   => self::get_actions( 'product_action', 'frontend' ),
			'nonces'                    => self::get_nonce( 'product_action', 'frontend' ),
		);
		wp_register_script( 'ywdpd_frontend', YITH_YWDPD_ASSETS_URL . '/js/' . yit_load_js_file( 'frontend.js' ), array( 'jquery' ), YITH_YWDPD_VERSION, true );
		wp_register_style( 'yith_ywdpd_frontend', YITH_YWDPD_ASSETS_URL . '/css/frontend.css', false, YITH_YWDPD_VERSION );

		wp_localize_script( 'ywdpd_frontend', 'ywdpd_qty_args', $args );

	}

	/**
	 * Register style and script in admin
	 *
	 * @author YITH
	 * @since 3.0.0
	 */
	public static function register_admin_scripts() {

		wp_register_style( 'yith_ywdpd_backend', YITH_YWDPD_ASSETS_URL . '/css/backend.css', array( 'woocommerce_admin_styles' ), YITH_YWDPD_VERSION );
		wp_register_script( 'yith_ywdpd_timepicker', YITH_YWDPD_ASSETS_URL . '/js/jquery-ui-timepicker-addon.min.js', array( 'jquery' ), YITH_YWDPD_VERSION, true );
		wp_register_script(
			'yith_ywdpd_admin',
			YITH_YWDPD_ASSETS_URL . '/js/' . yit_load_js_file( 'admin.js' ),
			array(
				'jquery',
				'jquery-ui-sortable',
				'jquery-ui-dialog',
			),
			YITH_YWDPD_VERSION,
			true
		);

		wp_localize_script(
			'yith_ywdpd_admin',
			'yith_ywdpd_admin',
			apply_filters(
				'yith_ywdpd_admin_localize',
				array(
					'ajax_url'        => admin_url( 'admin-ajax.php', is_ssl() ? 'https' : 'http' ),
					'actions'         => self::get_actions( 'table_rule', 'admin' ),
					'nonces'          => self::get_nonce( 'table_rule', 'admin' ),
					'del_msg'         => apply_filters( 'yith_ywdpd_delete_msg_admin', __( 'Do you really want to delete this rule?', 'ywdpd' ) ),
					'currency_symbol' => get_woocommerce_currency_symbol(),
					'percent_symbol'  => '%',
					'labels'          => array(
						'rule_type' => array(
							'bulk'              => array(
								'rule_for'                 => array( 'label' => __( 'Create a quantity rule for the purchase of:', 'ywdpd' ) ),
								'quantity_based'           => array( 'label' => __( 'Quantity rule will check', 'ywdpd' ) ),
								'user_rules'               => array( 'label' => __( 'Apply discount to', 'ywdpd' ) ),
								'schedule_discount_mode'   => array( 'label' => __( 'Schedule discount', 'ywdpd' ) ),
								'table_note_apply_to'      => array(
									'label' => __( 'Add a custom message in product with quantity rule', 'ywdpd' ),
								),
								'enable_user_rule_exclude' => array(
									'label' => __( 'Exclude users from this discount', 'ywdpd' ),
									'desc'  => __( 'Enable if you want to exclude specific users from this discount', 'ywdpd' ),
								),
							),
							'special_offer'     => array(
								'rule_for'                 => array( 'label' => __( 'Create a special offer rule for the purchase of:', 'ywdpd' ) ),
								'quantity_based'           => array( 'label' => __( 'Set offer based on', 'ywdpd' ) ),
								'user_rules'               => array( 'label' => __( 'Apply special offer to', 'ywdpd' ) ),
								'schedule_discount_mode'   => array( 'label' => __( 'Schedule offer', 'ywdpd' ) ),
								'table_note_apply_to'      => array(
									'label' => __( 'Add a custom message in product with special offer', 'ywdpd' ),
								),
								'enable_user_rule_exclude' => array(
									'label' => __( 'Exclude users from this discount', 'ywdpd' ),
									'desc'  => __( 'Enable if you want to exclude specific users from this discount', 'ywdpd' ),
								),
								'repeat'                   => array(
									'desc' => __( 'Enable this option to repeat the rule. For example, if you offer a 50% discount when purchasing a second product, when the user purchases four products, the rule is applied twice and the user gets a 50% discount on two of the four purchased products.', 'ywdpd' ),
								),
							),
							'gift_products'     => array(
								'rule_for'                 => array( 'label' => __( 'Offer gifts if user buy', 'ywdpd' ) ),
								'quantity_based'           => array( 'label' => __( 'Quantity rule will check', 'ywdpd' ) ),
								'user_rules'               => array( 'label' => __( 'Offer gift products to', 'ywdpd' ) ),
								'schedule_discount_mode'   => array( 'label' => __( 'Schedule rule', 'ywdpd' ) ),
								'table_note_apply_to'      => array(
									'label' => __( 'Add a custom message in products where the rule is applied', 'ywdpd' ),
								),
								'enable_user_rule_exclude' => array(
									'label' => __( 'Exclude users from this rule', 'ywdpd' ),
									'desc'  => __( 'Enable if you want to exclude specific users from this rule', 'ywdpd' ),
								),
							),
							'discount_whole'    => array(
								'user_rules'               => array( 'label' => __( 'Apply discount to', 'ywdpd' ) ),
								'table_note_apply_to'      => array(
									'label' => __( 'Add a custom message in products with discount applied', 'ywdpd' ),
								),
								'enable_user_rule_exclude' => array(
									'label' => __( 'Exclude users from this discount', 'ywdpd' ),
									'desc'  => __( 'Enable if you want to exclude specific users from this discount', 'ywdpd' ),
								),
							),
							'category_discount' => array(
								'user_rules'               => array( 'label' => __( 'Apply discount to', 'ywdpd' ) ),
								'table_note_apply_to'      => array(
									'label' => __( 'Add a custom message in products with discount applied', 'ywdpd' ),
								),
								'enable_user_rule_exclude' => array(
									'label' => __( 'Exclude users from this discount', 'ywdpd' ),
									'desc'  => __( 'Enable if you want to exclude specific users from this discount', 'ywdpd' ),
								),
							),
							'bogo'              => array(
								'rule_for'            => array( 'label' => __( 'Create a BOGO rule for the purchase of:', 'ywdpd' ) ),
								'user_rules'          => array( 'label' => __( 'Apply BOGO rule to', 'ywdpd' ) ),
								'table_note_apply_to' => array(
									'label' => __( 'Add a custom message in products with the BOGO offer', 'ywdpd' ),
								),
							),
						),
					),
					'message_alert'   => array(
						'title' => __( 'This is a deprecated rule', 'ywdpd' ),
						'desc'  => __( 'From version 2.0 we removed the “Exclude” rule and added in all discount rules an option to exclude products/categories/tags. For example if you create a rule for a discount directly in the rule you can exclude products. We suggest you to replace this deprecated rule using the “Exclude” option in the other rules', 'ywdpd' ),
					),
				)
			)
		);
		if ( isset( $_GET['action'] ) && 'edit' === sanitize_text_field( wp_unslash( $_GET['action'] ) ) ) { //phpcs:ignore
			$css_inline = '.yith-plugin-ui--ywdpd_discount-post_type .page-title-action {
						display:none!important;
					}';

			wp_add_inline_style( 'yith_ywdpd_backend', $css_inline );
		}


		wp_register_style( 'ywdpd_exclusion', YITH_YWDPD_ASSETS_URL . '/css/exclusion-list.css', array(), YITH_YWDPD_VERSION );
		wp_register_script( 'ywdpd_exclusion', YITH_YWDPD_ASSETS_URL . '/js/exclusion-list-popup.js', array( 'jquery' ), YITH_YWDPD_VERSION, true );
		ob_start();
		include YITH_YWDPD_VIEW_PATH . '/panel/custom-tabs/ywdpd-exclusions-popup.php';
		$popup = ob_get_clean();
		$args  = array(
			'popup_add_title' => __( 'Add an exclusion to the list', 'ywdpd' ),
			'content'         => $popup,
		);
		wp_localize_script( 'ywdpd_exclusion', 'ywdpd_exclusion_list', $args );
	}

	/**
	 * Build the actions array for the scripts
	 *
	 * @param string $type The type of the actions.
	 * @param string $context Admin or frontend.
	 *
	 * @return array
	 * @since 3.0.0
	 *
	 * @author YITH
	 */
	public static function get_actions( $type, $context = 'admin' ) {
		$actions = array();
		if ( 'admin' === $context ) {
			$type_actions = isset( self::$ajax_backend_actions[ $type ] ) ? self::$ajax_backend_actions[ $type ] : array();
		} else {
			$type_actions = isset( self::$ajax_frontend_actions[ $type ] ) ? self::$ajax_frontend_actions[ $type ] : array();
		}

		foreach ( $type_actions as $action ) {
			$actions[ $action ] = 'ywdpd_' . $action;
		}

		return $actions;
	}

	/**
	 * Create the nonce for the the script
	 *
	 * @param string $type The type of the actions.
	 * @param string $context Admin or frontend.
	 *
	 * @return array
	 * @author YITH
	 * @since 3.0.0
	 */
	public static function get_nonce( $type, $context = 'admin' ) {
		$nonces = array();
		if ( 'admin' === $context ) {
			$type_actions = isset( self::$ajax_backend_actions[ $type ] ) ? self::$ajax_backend_actions[ $type ] : array();
		} else {
			$type_actions = isset( self::$ajax_frontend_actions[ $type ] ) ? self::$ajax_frontend_actions[ $type ] : array();
		}

		foreach ( $type_actions as $action ) {
			$nonces[ $action ] = wp_create_nonce( str_replace( '_', '-', $action ) );
		}

		return $nonces;
	}

	/**
	 * Enqueue the frontend scripts
	 *
	 * @author YITH
	 * @since 3.0.0
	 */
	public static function enqueue_frontend_scripts() {

		self::register_frontend_scripts();
		// Enqueue the popup script only on cart or single product page.
		wp_enqueue_script( 'ywdpd_popup' );
		wp_enqueue_script( 'ywdpd_owl' );
		wp_enqueue_script( 'ywdpd_frontend' );
		wp_enqueue_style( 'ywdpd_owl' );
		wp_enqueue_style( 'yith_ywdpd_frontend' );

		if ( ! wp_script_is( 'wc-add-to-cart-variation' ) ) {
			wp_enqueue_script( 'wc-add-to-cart-variation' );
		}
	}

	/**
	 * Enqueue the admin script and style
	 *
	 * @author YITH
	 * @since 3.0.0
	 */
	public static function enqueue_admin_scripts() {

		self::register_admin_scripts();
		$screen    = get_current_screen();
		$screen_id = $screen ? $screen->id : '';

		if ( 'edit-ywdpd_discount' === $screen_id ) {
			wp_enqueue_script( 'yith-plugin-fw-fields' );
		}
		if ( ywdpd_check_valid_admin_page( 'ywdpd_discount' ) || ( isset( $_GET['page'] ) && 'yith_woocommerce_dynamic_pricing_and_discounts' === sanitize_text_field( wp_unslash( $_GET['page'] ) ) ) ) {  // phpcs:ignore WordPress.Security.NonceVerification.Recommended
			wp_enqueue_script( 'jquery-ui-datepicker' );
			wp_enqueue_style( 'yith_ywdpd_backend' );
			wp_enqueue_script( 'yith_ywdpd_timepicker' );
			wp_enqueue_script( 'yith_ywdpd_admin' );

			if ( ! wp_script_is( 'selectWoo' ) ) {
				wp_enqueue_script( 'selectWoo' );
				wp_enqueue_script( 'wc-enhanced-select' );
			}

			if ( isset( $_GET['tab'] ) && 'exclusions' === sanitize_text_field( wp_unslash( $_GET['tab'] ) ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
				wp_enqueue_script( 'yith-plugin-fw-wp-pages' );
			}
		}
	}
}

YWDPD_Assets::init();
