<?php // phpcs:ignore WordPress.Files.FileName
/**
 * The class that manage the plugin options
 *
 * @package  YITH\Dynamic\PricingAndDiscounts\Classes
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'YITH_WC_Dynamic_Options' ) ) {
	/**
	 * The Class that manage options
	 */
	class YITH_WC_Dynamic_Options {

		/**
		 * Get option to check if shop manager is enabled
		 *
		 * @return bool
		 * @author YITH
		 * @since 1.7.0
		 */
		public static function is_shop_manager_enabled() {

			$value = get_option( 'ywdpd_enable_shop_manager', 'no' );

			return yith_plugin_fw_is_true( $value );

		}

		/**
		 * Get option to get the price format
		 *
		 * @return string
		 * @author YITH
		 * @since 1.7.0
		 */
		public static function get_price_format() {

			$value = get_option( 'ywdpd_price_format', '<del>%original_price%</del> %discounted_price%' );

			return $value;
		}

		/**
		 * Check if is possible show notes in product
		 *
		 * @return bool
		 * @since 1.7.0
		 * @author YITH
		 */
		public static function show_note_on_products() {

			$value = get_option( 'ywdpd_show_note_on_products', 'yes' );

			return yith_plugin_fw_is_true( $value );
		}

		/**
		 * Get the position where show the notice
		 *
		 * @return string
		 * @since 1.7.0
		 * @author YITH
		 */
		public static function get_show_note_on_products_place() {

			$value = get_option( 'ywdpd_show_note_on_products_place', 'before_add_to_cart' );

			return $value;
		}

		/**
		 * Check if show quantity table
		 *
		 * @return bool
		 * @since 1.7.0
		 * @author YITH
		 */
		public static function show_quantity_table() {

			$value = get_option( 'ywdpd_show_quantity_table', 'yes' );

			return yith_plugin_fw_is_true( $value );
		}


		/**
		 * Get the quantity table layout
		 *
		 * @return string
		 * @since 1.7.0
		 * @author YITH
		 */
		public static function get_quantity_table_layout() {

			if ( wp_is_mobile() ) {
				$value = get_option( 'ywdpd_quantity_table_orientation_mobile', 'horizontal' );
			} else {
				$value = get_option( 'ywdpd_quantity_table_orientation', 'horizontal' );
			}

			return $value;
		}

		/**
		 * Get the position where show the quantity table
		 *
		 * @return string
		 * @since  1.7.0
		 * @author YITH
		 */
		public static function get_quantity_table_position() {

			$value = get_option( 'ywdpd_show_quantity_table_place', 'before_add_to_cart' );

			return $value;
		}

		/**
		 * Get the quantity table title
		 *
		 * @return string
		 * @since 1.7.0
		 * @author YITH
		 */
		public static function get_quantity_table_title() {
			$value = get_option( 'ywdpd_show_quantity_table_label', __( 'Discount per quantity', 'ywdpd' ) );

			return $value;
		}

		/**
		 * Get the columns table label for the quantity table
		 *
		 * @return array
		 * @since 1.7.0
		 * @author YITH
		 */
		public static function get_quantity_columns_table_title() {

			$value = get_option(
				'ywdpd_quantity_table_labels',
				array(
					'quantity' => __( 'Quantity', 'ywdpd' ),
					'price'    => __( 'Price', 'ywdpd' ),
					'discount' => __( '% Discount', 'ywdpd' ),
				)
			);

			return $value;
		}

		/**
		 * Check if show the schedule dates on quantity table
		 *
		 * @return bool
		 * @since 1.7.0
		 * @author YITH
		 */
		public static function show_quantity_table_schedule() {

			$value = get_option( 'ywdpd_show_quantity_table_schedule', 'yes' );

			return yith_plugin_fw_is_true( $value );
		}

		/**
		 *
		 * Return what price show on products
		 *
		 * @return string
		 * @since 1.7.0
		 * @author YITH
		 */
		public static function get_default_price() {

			$value = get_option( 'ywdpd_show_as_default', 'min' );

			return $value;
		}

		/**
		 * Check if the default qty is auto selected on the quantity table
		 *
		 * @return bool
		 * @since 1.7.0
		 * @author YITH
		 */
		public static function is_default_qty_selected() {

			$value = get_option( 'ywdpd_default_qty_selected', 'no' );

			return yith_plugin_fw_is_true( $value );
		}

		/**
		 * Check if update the product price if the quantity change
		 *
		 * @return bool
		 * @since 1.7.0
		 * @author YITH
		 */
		public static function update_price_on_qty_changes() {

			$value = get_option( 'ywdpd_update_price_on_qty', 'yes' );

			return yith_plugin_fw_is_true( $value );
		}

		/**
		 * Get the coupon label
		 *
		 * @return string
		 * @since 1.7.0
		 * @author YITH
		 */
		public static function get_coupon_label() {

			$value = get_option( 'ywdpd_coupon_label', 'DISCOUNT' );

			return $value;
		}

		/**
		 * Get how calculate the discount in the cart
		 *
		 * @return string
		 * @since 1.7.0
		 * @author YITH
		 */
		public static function how_calculate_discounts() {
			$value = get_option( 'ywdpd_calculate_discounts_tax', 'tax_excluded' );

			return $value;
		}

		/**
		 * Check if is possible extend the rules with wpml
		 *
		 * @return bool
		 * @since 1.7.0
		 * @author YITH
		 */
		public static function can_wpml_extend_to_translated_object() {

			$value = get_option( 'ywdpd_wpml_extend_to_translated_object', 'no' );

			return defined( 'ICL_SITEPRESS_VERSION' ) && ( true === $value || 1 === $value || '1' === $value || 'yes' === $value || 'true' === $value );

		}

		/**
		 * Show how the cart item price if the special offer is applied
		 *
		 * @return string
		 * @since 2.0
		 * @author YITH
		 */
		public static function how_show_special_offer_subtotal() {

			$value = get_option( 'ywdp_cart_special_offer_show_subtotal_mode', 'unit_price' );

			return $value;
		}

		/**
		 * Check if is possible show the discount info in the cart
		 *
		 * @return bool
		 * @since 2.0
		 * @author YITH
		 */
		public static function show_discount_info_in_cart() {

			$value = get_option( 'ywdpd_enable_cart_notices', 'no' );

			return 'yes' === $value;
		}

		/**
		 * Get the discount message
		 *
		 * @return string
		 * @since 2.0
		 * @author YITH
		 */
		public static function get_discount_info_message() {

			$value = get_option( 'ywdpd_cart_notice_message', __( 'Please note: you\'ve saved %total_discount_percentage% on this order today', 'ywdpd' ) );

			return $value;
		}

		/**
		 * Check if is possible show the discount column in the table
		 *
		 * @return bool
		 * @since 3.0.0
		 * @author YITH
		 */
		public static function can_show_discount_column() {

			$value = get_option( 'ywdpd_show_percentage_in_table', 'off' );

			return yith_plugin_fw_is_true( $value );
		}

		/**
		 * Get the type of the quantity heading
		 *
		 * @return string
		 * @since 3.0.0
		 * @author YITH
		 */
		public static function get_table_type_heading() {
			$value = get_option( 'ywdpd_qty_table_type_heading', 'all' );

			return $value;
		}

		/**
		 * Get how show the coupon label in the cart
		 *
		 * @return string
		 * @since 3.0.0
		 * @author YITH
		 */
		public static function get_coupon_label_mode() {
			return get_option( 'ywdpd_cart_label_mode', 'default_name' );
		}

		/**
		 * Check if show or not the rule details in the customer emails
		 *
		 * @return bool
		 * @since 3.1.0
		 * @author YITH
		 */
		public static function can_show_rule_details() {
			return yith_plugin_fw_is_true( get_option( 'ywdpd_show_rule_details', 'yes' ) );
		}

	}
}
